function doComposeMail(email){
	invokeAppFunction('ComposeMail', {email: email});
}
function doFindRelatedMail(email){
	invokeAppFunction('FindRelatedMail', {email: email});
}
function doShowContactDetails(email){
	invokeAppFunction('ShowContactDetails', {email: email});
}
function doAddContact(name, email, x, y){
	invokeAppFunction('AddContact', {name: name, email: email, x: x, y: y});
}

//zoom
function zoomIFrame(dom, zoomValue, zoomWeight, maxDelta, minDelta, bInOut){
	if (dom){
		var contentWindow = dom.contentWindow;
		if (contentWindow.document){
			var body = contentWindow.document.body;
			if (body){
				if (bInOut){
					var newValue = 1;
					if (body.style.zoom){
						newValue = body.style.zoom;
					}
					newValue = ((newValue * zoomWeight) + zoomValue);
					if (newValue >= minDelta && newValue <= maxDelta){
						body.style.zoom = newValue / zoomWeight;
					}
				}else{
					if (zoomValue >= minDelta && zoomValue <= maxDelta){
						body.style.zoom = zoomValue / zoomWeight;
					}
				}
			}
		}
	}
}
function getCurZoomValue(params){
	var mailid = params.getValue('mailid');
	var iframe = document.getElementById('iframe_'+mailid);
	if (iframe){
		var contentWindow = iframe.contentWindow;
		if (contentWindow){
			if (contentWindow.document){
				if (contentWindow.document.body){
					var body = contentWindow.document.body;
					if (body.style.zoom){
						return body.style.zoom * 100;
					}
				}
			}
		}
	}
	return 0;
}
function doMailContentZoom(params){
	try{
		var bChangeAll = params.getValue('bChangeAll');
		var bInOut = params.getValue('bInOut');
		var nMaxDelta = params.getValue('nMaxDelta');
		var nMinDelta = params.getValue('nMinDelta');
		var nWeight = params.getValue('nWeight');
		if (bChangeAll){
			if (bInOut){
				var nPerDelta = params.getValue('nPerDelta');
				var sessionElements = $('.mail_session_expand');
				for (var i=0; i<sessionElements.length; i++){
					var mailid = $(sessionElements[i]).attr('mailid');
					var iframe = document.getElementById('iframe_'+mailid);
					zoomIFrame(iframe, nPerDelta, nWeight, nMaxDelta, nMinDelta, true);
				}
			}else{
				var nDelta = params.getValue('nDelta');
				var sessionElements = $('.mail_session_expand');
				for (var i=0; i<sessionElements.length; i++){
					var mailid = $(sessionElements[i]).attr('mailid');
					var iframe = document.getElementById('iframe_'+mailid);
					zoomIFrame(iframe, nDelta, nWeight, nMaxDelta, nMinDelta, false);
				}
			}
			adjustExpandMailContentSize(true);
		}else{
			var mailid = params.getValue('mailid');//target
			var iframe = document.getElementById('iframe_'+mailid);
			if (iframe){
				if (bInOut){
					var nPerDelta = params.getValue('nPerDelta');
					zoomIFrame(iframe, nPerDelta, nWeight, nMaxDelta, nMinDelta, true);
				}else{
					var nDelta = params.getValue('nDelta');
					zoomIFrame(iframe, nDelta, nWeight, nMaxDelta, nMinDelta, false);
				}
				adjustExpandMailContentSize(true);
			}
		}
	}catch(e){
		WriteLog('doMailContentZoom', e.message);
	}
}
function doUpdateMailReadMark(mailid, bRead){
	var sessionElement = $("#mail_head_collapse_"+mailid);
	if (bRead){
		if (sessionElement.hasClass("mail_head_collapse_readmark_unread")) {
			sessionElement.removeClass("mail_head_collapse_readmark_unread");
			sessionElement.addClass("mail_head_collapse_readmark_read");
		}
		var markItem = $(".mail_head_readmark_unread", sessionElement);
		markItem.removeClass("mail_head_readmark_unread");
		markItem.addClass("mail_head_readmark_read");
	}else{
		if (sessionElement.hasClass("mail_head_collapse_readmark_read")) {
			sessionElement.removeClass("mail_head_collapse_readmark_read");
			sessionElement.addClass("mail_head_collapse_readmark_unread");
		}
		var markItem = $(".mail_head_readmark_read", sessionElement);
		markItem.removeClass("mail_head_readmark_read");
		markItem.addClass("mail_head_readmark_unread");
	}
}
function updateMailReadMark(params){
	var mailid = params.getValue('mailid');
	var bRead = params.getValue('bRead');
	doUpdateMailReadMark(mailid, bRead);
}
function setMailReadMark(mailid, bRead) {
	try{
		invokeAppFunction('SetMailReadMark', {
			mailid: mailid,
			read: bRead
		});
		//更新界面
		doUpdateMailReadMark(mailid, bRead);
	}catch(e){
		WriteLog('setMailReadMark', e.message);
	}
}

//窗口大小调整
function adjustMailFrameSize() {
	var date1 = new Date();

	try{
		var width = document.documentElement.clientWidth || document.body.clientWidth;
		var height = document.documentElement.clientHeight || document.body.clientHeight;
		var width_fix = 0;
		var scrollbar = getFoxWBScrollbar(vertscrollbar_id);
		if (scrollbar){
			if (scrollbar.vertVisible()){
				// 右边滚动条宽度
				width_fix = scrollbar.getVertWidth();
			}
		}

		$(".mail_frame").width(width);
		//$(".mail_session_container").width(width-width_fix);
		$(".mail_session_container").height(height);
	}catch(e){
		WriteLog('adjustMailFrameSize', e.message);
	}

	var date2 = new Date();
	doAddDebugMsg('调整框架大小耗时: ' + (date2.getTime()-date1.getTime()));
}

function adjustMailContentSize(mailid, bUpdateVertScrollbar, resizeContent) {
	var date1 = new Date();
	try{
		var minHeight = 200;
		var sessionCount = parseInt($('#foxmail_view_body').attr('sessionCount'));
		var sessionHeight = 0;
		if (sessionCount == 1){
			var sessionPanel = $('#mail_session_panel_'+mailid);
			if (sessionPanel.length > 0){
				sessionTop = sessionPanel.offset().top;
				var documentHeight = document.documentElement.clientHeight || document.body.clientHeight;
				var currentHeight = sessionPanel.height() + sessionTop;
				sessionHeight = documentHeight - sessionTop - 20;
				minHeight = sessionHeight - 200;
			}
		}

		var obj = document.getElementById("iframe_"+mailid);
		var bodyHeight = 0;
		var contentWindow = obj.contentWindow;
		var body = contentWindow.document.body;
		if (!body) {
			//$('#mail_content_iframe_'+mailid).css('height', minHeight+'px');
			//$(obj).css('height', 'auto'); 
			return;
		}
		if (resizeContent){
			//Fixme 将iframe设置回默认最小大小 在改变窗口大小时能正确获取到内容高度 
			$(obj).css('height', minHeight+'px');
			//get scrollHeight
			var renderCounter = 0;
			var maxRenderCounter = 100; //
			var clientHeight = contentWindow.document.documentElement.scrollHeight;
			while (clientHeight != contentWindow.document.documentElement.scrollHeight){
				clientHeight = contentWindow.document.documentElement.scrollHeight;
				if (renderCounter > maxRenderCounter) break;
				renderCounter ++;
			}
			renderCounter = 0;
			bodyHeight = contentWindow.document.body.scrollHeight;
			while (bodyHeight != contentWindow.document.body.scrollHeight){
				bodyHeight = contentWindow.document.body.scrollHeight;
				if (renderCounter > maxRenderCounter) break;
				renderCounter ++;
			}
			bodyHeight = Math.max(bodyHeight, clientHeight);
			if (body.style.zoom){
				bodyHeight = bodyHeight * body.style.zoom;
			}else{
				//zoom
				var zoomValue = invokeAppFunction('GetCurZoomValue', {}) / 100;
				if (zoomValue != 1){
					body.style.zoom = zoomValue;
				}
				bodyHeight = bodyHeight * zoomValue;
			}

			if (bodyHeight < minHeight){
				bodyHeight = minHeight;
			}
			$('#mail_content_iframe_'+mailid).css('height', bodyHeight+'px');
			$(obj).css('height', bodyHeight+'px');
		}

		//只有一个会话时候 调整页面占据整个窗口
		if (sessionCount == 1){
			var attachTop = 0;
			var attachHeight = 0;
			var attachmentAreaDOM = document.getElementById('attachment_area_'+mailid);
			if (attachmentAreaDOM){
				var attachmentArea = $(attachmentAreaDOM);
				attachTop = attachmentArea.offset().top;
				attachHeight = attachmentArea.outerHeight(false);
			}
			//mail_session_panel
			var documentHeight = document.documentElement.clientHeight || document.body.clientHeight;
			var sessionTop = 0;
			var sessionPanelDOM = document.getElementById('mail_session_panel_'+mailid);
			if (sessionPanelDOM){
				sessionTop = $(sessionPanelDOM).offset().top;
			}
			var currentHeight = 0;
			if (attachTop > 0){
				currentHeight = attachTop + attachHeight + 40;
			}else{
				var top = $(obj).offset().top;
				var height = $(obj).height();
				currentHeight = top + height + 40;
			}
			if (currentHeight > documentHeight){
				$('#mail_session_panel_'+mailid).css('height', 'auto');
			}else {
				var sessionHeight = documentHeight - sessionTop - 20;
				$('#mail_session_panel_'+mailid).css('height', sessionHeight+'px');
			}
		}

		if (bUpdateVertScrollbar){
			updateVertScrollbar();
		}
	}catch(e){
		WriteLog('adjustMailContentSize', e.message);
	}
	var date2 = new Date();
	doAddDebugMsg('调整iframe大小耗时: '+(date2.getTime()-date1.getTime()));
}

function hideLoadingAnimate(mailid) {
	$("#mail_content_loading_"+mailid).addClass("hide_ifzero_0");
}